/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include "Log.h"

#include "SliderSubdivision.h"
#include "Subdivision.h"

using namespace std;
using namespace LayerManagerCalibration;

bool SliderSubdivision::validate()
{
    bool valid = true;

    // verify that a minimum value was defined
    if (!m_bMinimumValueParsed)
    {
        LOG_WARNING("SliderSubdivision", "No minimum value defined");
        valid = false;
    }

    // verify that a maximum value was defined
    if (!m_bMaximumValueParsed)
    {
        LOG_WARNING("SliderSubdivision", "No maximum value defined");
        valid = false;
    }

    // verify that a orientation value was defined
    if (!m_bOrientationParsed)
    {
        LOG_WARNING("SliderSubdivision", "No orientation defined");
        valid = false;
    }

    // verify that minimum value <= maximum value
    if (valid && m_fpMinimumValue > m_fpMaximumValue)
    {
        LOG_WARNING("SliderSubdivision",
                    "Minimum value="
                    << m_fpMinimumValue
                    << " is greater than maximum value="
                    << m_fpMaximumValue);
        valid = false;
    }

    return valid;
}

bool SliderSubdivision::handleUnknownKey(const string& key, const string& value)
{
    if (key.compare("minimum value") == 0)
    {
        istringstream iss(value);
        iss >> m_fpMinimumValue;

        if (iss.fail())
        {
            LOG_WARNING("SliderSubdivision",
                        "Found invalid minimum value=" << value);
            return false;
        }
        else
        {
            LOG_INFO("SliderSubdivision",
                     "Found minimum value=" << m_fpMinimumValue);
        }

        m_bMinimumValueParsed = true;
    }
    else if (key.compare("maximum value") == 0)
    {
        istringstream iss(value);
        iss >> m_fpMaximumValue;

        if (iss.fail())
        {
            LOG_WARNING("SliderSubdivision",
                        "Found invalid maximum value=" << value);
            return false;
        }
        else
        {
            LOG_INFO("SliderSubdivision",
                     "Found maximum value=" << m_fpMaximumValue);
        }

        m_bMaximumValueParsed = true;
    }
    else if (key.compare("orientation") == 0)
    {
        if (value.compare("horizontal") == 0)
        {
            m_eOrientation = HORIZONTAL;
            LOG_INFO("SliderSubdivision",
                     "Found orientation=" << m_eOrientation);
        }
        else if (value.compare("vertical") == 0)
        {
            m_eOrientation = VERTICAL;
            LOG_INFO("SliderSubdivision",
                     "Found orientation=" << m_eOrientation);
        }
        else
        {
            LOG_WARNING("SliderSubdivision",
                        "Found invalid orientation: " << value);
            return false;
        }

        m_bOrientationParsed = true;
    }
    else
    {
        return false;
    }

    return true;
}
